
rm(list=ls())
library(dplyr)
library(Synth)

dat = read.csv("../RAS.csv", header=TRUE)

dat$country = as.character(dat$country)

dat = dat[, c("country", "ctyid", "year", "muslim", 
              "state", "social")]

width=3200
height=2400
res = 300
time = 1990:2014


# combine Egypt, Tunisia, Yemen, Libya because Egypt's social hostilities
# are the highest no synthetic control can be created for it
egypt.libya.tunisia.yemen = aggregate(dat[dat$country %in% c("Egypt","Tunisia", "Yemen", "Libya") , c("state", "social")],
                                by=list(year=dat[dat$country %in% c("Egypt","Tunisia", "Yemen", "Libya") , "year"]),
                                FUN = mean, na.rm=TRUE)

egypt.libya.tunisia.yemen = data.frame(country="Egypt.Libya.Tunisia.Yemen", ctyid=1000, muslim=1, egypt.libya.tunisia.yemen)
dat = rbind(dat, egypt.libya.tunisia.yemen)


##############################################################
# Create not.in function to make life easier
##############################################################
`%not.in%` <- function(x,y)!('%in%'(x,y))



##############################################################
# Delete Incomplete Countries
##############################################################

num.missing <- function(x) {
  return (sum(is.na(x)))
}

dat.temp = dat
out = aggregate(x=dat.temp, by=list(country=dat.temp$country), FUN=num.missing)

has.missing = rowSums((out[,-1])) > 0
countries.without.missing = out$country[!has.missing]

dat = dat[dat$country %in% countries.without.missing,]



##############################################################
######### DRAW 
##############################################################

draw <- function(mat, focus, x.range, ylim, ylab, time.v, text.x, text.y, text, all.mean, legend.lab) {
  par(mar=c(10, 4.1, 4.1, 2.1), xpd=TRUE)
  
  plot(x.range, focus,
       type="l", ylim=ylim, 
       col=rgb(0,0,0,alpha=.7), lty="solid",
       ylab = ylab,
       xlab ="Year",
       lwd=6,
       axes = FALSE,
       cex.lab = 1.5
  )
  axis(side=1, at=seq(time[1], time[length(time)], 2))
  axis(side=2, at=seq(ylim[1], ylim[2], 5))
  
  lines(x=c(time.v,time.v), y=c(0,ylim[2]), lty="dotted")
  lines(x=c(time.v-1,time.v-1), y=c(0,ylim[2]), lty="dotted")
  
  text(text.x-.5, text.y, text, cex=1.4)
  
  
  for (i in 1:(nrow(mat))) {
    lines(x.range, mat[i,], lwd=1.2, lty="dashed")  
  }
  
  lines(x.range, all.mean, lwd=6, lty="dashed", col=rgb(0,0,0,alpha=.7))
  
  legend(x="bottom", inset=c(0,-.28),
         legend=legend.lab,
         lty=c("solid","dashed"),col=c("black","black"),
         cex=1.2,bg="white",lwd=c(2,2), 
         ncol=2)
}




dat.muslim = dat[(dat$muslim==1),]
list.muslim = unique(dat.muslim$country[dat.muslim$country %not.in% c("Egypt", "Libya", "Tunisia", "Yemen", "Egypt.Libya.Tunisia.Yemen")])

list.regime.change = c("Egypt", "Libya", "Tunisia", "Yemen", "Egypt.Libya.Tunisia.Yemen")


##############################################################
# state
##############################################################

dependent = "state"

mat = matrix(NA, nrow=length(list.muslim), ncol=length(time))


for (i in 1:length(list.muslim)) {
    mat[i,] = dat[dat$country==list.muslim[i] ,dependent]
}

all.mean = colMeans(mat[1:(nrow(mat)), ])

for (cty in list.regime.change) {
  png(filename = paste0("Government ", cty, ".png"), width=width, height=height, res=res)
  draw(mat, 
       focus = dat[dat$country == cty, dependent],
       x.range = time, 
       ylim = c(0,max(dat[dat$muslim==1,dependent])+5), 
       ylab = "Government Discrimination of Religious Minorities",
       time.v = 2011, 
       text.x = 2011, 
       text.y = 10, 
       text = "",
       all.mean = all.mean,
       legend.lab = c(cty,"Mean of Muslim Countries"))
  dev.off()
  
}




##############################################################
# social
##############################################################

dependent = "social"

mat = matrix(NA, nrow=length(list.muslim), ncol=length(time))


for (i in 1:length(list.muslim)) {
  mat[i,] = dat[dat$country==list.muslim[i] ,dependent]
}

all.mean = colMeans(mat[1:(nrow(mat)), ])

for (cty in list.regime.change) {
  png(filename = paste0("Societal ",cty, ".png"), width=width, height=height, res=res)
  draw(mat, 
       focus = dat[dat$country == cty, dependent],
       x.range = time, 
       ylim = c(0,max(dat[dat$muslim==1,dependent])+5), 
       ylab = "Societal Discrimination of Religious Minorities",
       time.v = 2011, 
       text.x = 2011, 
       text.y = 10, 
       text = "",
       all.mean = all.mean,
       legend.lab = c(cty,"Mean of Muslim Countries"))
  dev.off()
  
}

